/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp3;

import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp3.Demand;
import cz.insophy.inplan.mrp3.GorSupply;
import cz.insophy.inplan.mrp3.SrSupply;
import cz.insophy.inplan.mrp3.SuppliesCreator;
import cz.insophy.inplan.mrp3.Supply;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultSuppliesCreator
implements SuppliesCreator {
    private final long storeBuffer;

    public DefaultSuppliesCreator(long storeBuffer) {
        this.storeBuffer = storeBuffer;
    }

    public DefaultSuppliesCreator() {
        this(0L);
    }

    @Override
    public Collection<Supply> createSupplies(Demand first, double firstQty, Iterator<Demand> rest) {
        ArrayList<Supply> supplies = Lists.newArrayList();
        supplies.add(this.createSupply(first, firstQty));
        while (rest.hasNext()) {
            Demand demand = rest.next();
            supplies.add(this.createSupply(demand, demand.getQty()));
        }
        return supplies;
    }

    private Supply createSupply(Demand demand, double qty) {
        Material material = demand.getMaterial();
        long time = demand.getTime() - this.storeBuffer;
        Supply supply = material instanceof Product && !((Product)material).getActiongrams().isEmpty() ? this.createGorSupply(time, qty, (Product)material) : new SrSupply(time, qty, demand.getMaterial());
        return supply;
    }

    private GorSupply createGorSupply(long time, double qty, Product product) {
        return new GorSupply(time, qty, product);
    }
}

